<?php  
include_once 'db.php';

$productid = $_POST['productid'];

// Ensure all fields are properly sanitized and formatted
$productname = addcslashes($_POST['productname'], '\'"');
$productdesc = addcslashes($_POST['productdesc'], '\'"');
$salepricetax = str_replace(',', '', $_POST['salepricetax']);
$mrp = str_replace(',', '', $_POST['mrp']);
$taxpercentagevalue = $_POST['taxpercentagevalue'];
$purchasetaxid = $_POST['purchasetaxid'];
$munit = $_POST['munit'];
$categoryid = $_POST['categoryid'];
$eyoutube = $_POST['eyoutube'];
$minqty = $_POST['minqty'];
$maxqty = $_POST['maxqty'];
$barcode = $_POST['barcode'];
$hsn = $_POST['hsn'];
$shippingweight = $_POST['shippingweight'];
$variants = $_POST['variants'];
$mode = $_POST['mode'];
$saleprice = str_replace(',', '', $_POST['saleprice']);
$brand = $_POST['brand'] ? $_POST['brand'] : 'undefined'; // Handle undefined case
$qty = $_POST['qty'];
$purchaseprice = str_replace(',', '', $_POST['purchaseprice']);
$brandid = $_POST['brandid'] ? $_POST['brandid'] : '0'; // Handle default case

// Additional fields
$condition = $_POST['condition'];
$gender = $_POST['gender'];
$agegroup = $_POST['agegroup'];
$mpn = $_POST['mpn'];
$gtin = $_POST['gtin'];
$pattern = $_POST['pattern'];
$taxpercentagevaluenumber = $_POST['taxpercentagevaluenumber'];
$embedUrl = convertToEmbedUrl($eyoutube);

function convertToEmbedUrl($url) {
    $url = strtok($url, '?');
    if (strpos($url, 'https://youtu.be/') !== false) {
        $videoId = str_replace('https://youtu.be/', '', $url);
        return 'https://www.youtube.com/embed/' . $videoId;
    } elseif (strpos($url, 'https://youtube.com/shorts/') !== false) {
        $videoId = str_replace('https://youtube.com/shorts/', '', $url);
        return 'https://www.youtube.com/embed/' . $videoId;
    } elseif (strpos($url, 'https://www.youtube.com/watch?v=') !== false) {
        $videoId = str_replace('https://www.youtube.com/watch?v=', '', $url);
        return 'https://www.youtube.com/embed/' . $videoId;
    } else {
        return $url;
    }
}

if (empty($productid)) {
    // Generate SKU
    $sql3 = "SELECT CONCAT('SKU-', LPAD(COUNT(id) + 1, 5, '0')) AS sku FROM product";
    $sqlexecute = mysqli_query($connection, $sql3);     
    $row = mysqli_fetch_array($sqlexecute);
    $sku = $row['sku'];

    // Insert product
    $sql = "INSERT INTO product 
            (productname, productdesc, salepricetax, mrp, taxpercentagetext, purchasetax, munit, category, eyoutube, minqty, maxqty, barcode, hsn, shippingweight, variants, mode, saleprice, taxpercentage, brand, sku, qty, purchaseprice, brandid, conditions, gender, agegroup, mpn, gtin, pattern)
            VALUES ('$productname', '$productdesc', '$salepricetax', '$mrp', '$taxpercentagevalue', '$purchasetaxid', '$munit', '$categoryid', '$embedUrl', '$minqty', '$maxqty', '$barcode', '$hsn', '$shippingweight', '$variants', '$mode', '$saleprice', '$taxpercentagevaluenumber', '$brand', '$sku', '$qty', '$purchaseprice', '$brandid', '$condition', '$gender', '$agegroup', '$mpn', '$gtin', '$pattern')";

    if (mysqli_query($connection, $sql)) {
        $productid = mysqli_insert_id($connection); // Get the newly inserted product ID
    } else {
        echo "Error inserting product: " . mysqli_error($connection);
        exit; // Stop execution if there's an error
    }
} else {
    // Update existing product
    $sql = "UPDATE product 
            SET productname='$productname',
                productdesc='$productdesc',
                salepricetax='$salepricetax',
                mrp='$mrp',
                taxpercentage='$taxpercentagevaluenumber',
                purchasetax='$purchasetaxid',
                munit='$munit',
                category='$categoryid',
                eyoutube='$embedUrl',
                minqty='$minqty',
                maxqty='$maxqty',
                barcode='$barcode',
                hsn='$hsn',
                shippingweight='$shippingweight',
                variants='$variants',
                mode='$mode',
                saleprice='$saleprice',
                brand='$brand',
                qty='$qty',
                purchaseprice='$purchaseprice',
                brandid='$brandid',
                taxpercentagetext='$taxpercentagevalue',
                conditions='$condition',
                gender='$gender',
                agegroup='$agegroup',
                mpn='$mpn',
                gtin='$gtin',
                pattern='$pattern'
            WHERE id='$productid'";

    if (!mysqli_query($connection, $sql)) {
        echo "Error updating product: " . mysqli_error($connection);
        exit; // Stop execution if there's an error
    }
}

// Handle file uploads after successfully inserting or updating product
$uploadsDirectory = 'images/product/';
if (isset($_FILES['files']) && !empty($_FILES['files']['tmp_name'][0])) {
    foreach ($_FILES['files']['tmp_name'] as $key => $tmp_name) {
        if ($_FILES['files']['error'][$key] == UPLOAD_ERR_OK) {
            $uploadFile = $uploadsDirectory . uniqid('img_') . '_' . basename($_FILES['files']['name'][$key]);

            // Resize the image before saving
            resizeImage($tmp_name, $uploadFile, 200, 200); 

            $imagesql = "INSERT INTO productimg (productid, productimg) VALUES ('$productid', '$uploadFile')"; 
            if (!mysqli_query($connection, $imagesql)) {
                echo "Error inserting image: " . mysqli_error($connection);
            }
        } else {
            echo "Error uploading file: " . $_FILES['files']['error'][$key];
        }
    }
} else {
    echo "No files uploaded.";
}

function resizeImage($sourceImage, $targetImage, $targetWidth, $targetHeight) {
    list($origWidth, $origHeight) = getimagesize($sourceImage);

    // Calculate aspect ratio
    $origAspect = $origWidth / $origHeight;
    $targetAspect = $targetWidth / $targetHeight;

    if ($origAspect >= $targetAspect) {
        // Image is wider than the target aspect ratio
        $newHeight = $targetHeight;
        $newWidth = intval($origWidth * ($targetHeight / $origHeight));
    } else {
        // Image is taller than the target aspect ratio
        $newWidth = $targetWidth;
        $newHeight = intval($origHeight * ($targetWidth / $origWidth));
    }

    // Resize the image to fit within the target dimensions
    $image_p = imagecreatetruecolor($newWidth, $newHeight);
    $image = imagecreatefromjpeg($sourceImage);
    imagecopyresampled($image_p, $image, 0, 0, 0, 0, $newWidth, $newHeight, $origWidth, $origHeight);

    // Crop the resized image to the target dimensions
    $croppedImage = imagecreatetruecolor($targetWidth, $targetHeight);
    $cropX = ($newWidth - $targetWidth) / 2;
    $cropY = ($newHeight - $targetHeight) / 2;
    imagecopy($croppedImage, $image_p, 0, 0, $cropX, $cropY, $targetWidth, $targetHeight);

    // Save the resized and cropped image
    imagejpeg($croppedImage, $targetImage, 90);

    // Clean up
    imagedestroy($image_p);
    imagedestroy($croppedImage);
    imagedestroy($image);
}
?>
